/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.algo;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.Transform;
import it.unimi.dsi.webgraph.UnionImmutableGraph;
import it.unimi.dsi.webgraph.algo.ParallelBreadthFirstVisit;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectedComponents {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectedComponents.class);
    public final int numberOfComponents;
    public final int[] component;

    protected ConnectedComponents(int numberOfComponents, int[] component) {
        this.numberOfComponents = numberOfComponents;
        this.component = component;
    }

    public static ConnectedComponents compute(ImmutableGraph symGraph, int threads, ProgressLogger pl) {
        ParallelBreadthFirstVisit visit = new ParallelBreadthFirstVisit(symGraph, threads, false, pl);
        visit.visitAll();
        AtomicIntegerArray visited = visit.marker;
        int numberOfComponents = visit.round + 1;
        visit = null;
        int[] component = new int[visited.length()];
        int i = component.length;
        while (i-- != 0) {
            component[i] = visited.get(i);
        }
        return new ConnectedComponents(numberOfComponents, component);
    }

    public static ImmutableGraph getLargestComponent(ImmutableGraph symGraph, int threads, ProgressLogger pl) {
        ParallelBreadthFirstVisit visit = new ParallelBreadthFirstVisit(symGraph, threads, false, pl);
        visit.visitAll();
        AtomicIntegerArray visited = visit.marker;
        int numberOfComponents = visit.round + 1;
        visit = null;
        int[] component = new int[visited.length()];
        int[] componentSizes = new int[numberOfComponents];
        int[] map = new int[symGraph.numNodes()];
        int largestCC = 0;
        int largestCCSize = Integer.MIN_VALUE;
        int i = component.length;
        while (i-- != 0) {
            component[i] = visited.get(i);
            int n = component[i];
            componentSizes[n] = componentSizes[n] + 1;
        }
        for (i = 0; i < componentSizes.length; ++i) {
            if (componentSizes[i] <= largestCCSize) continue;
            largestCC = i;
            largestCCSize = componentSizes[i];
        }
        i = symGraph.numNodes();
        while (i-- != 0) {
            if (component[i] == largestCC) {
                map[i] = --largestCCSize;
                continue;
            }
            map[i] = -1;
        }
        return Transform.map(symGraph, map, pl);
    }

    public int[] computeSizes() {
        int[] size = new int[this.numberOfComponents];
        int i = this.component.length;
        while (i-- != 0) {
            int n = this.component[i];
            size[n] = size[n] + 1;
        }
        return size;
    }

    public void sortBySize(int[] size) {
        int[] perm = Util.identity((int)size.length);
        IntArrays.parallelRadixSortIndirect((int[])perm, (int[])size, (boolean)false);
        IntArrays.reverse((int[])perm);
        int[] copy = (int[])size.clone();
        int i = size.length;
        while (i-- != 0) {
            size[i] = copy[perm[i]];
        }
        Util.invertPermutationInPlace((int[])perm);
        i = this.component.length;
        while (i-- != 0) {
            this.component[i] = perm[this.component[i]];
        }
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        ImmutableGraph graph;
        SimpleJSAP jsap = new SimpleJSAP(ConnectedComponents.class.getName(), "Computes the connected components of a symmetric graph of given basename. The resulting data is saved in files stemmed from the given basename with extension .wcc (a list of binary integers specifying the component of each node) and .wccsizes (a list of binary integer specifying the size of each component). The symmetric graph can also be specified using a generic (non-symmetric) graph and its transpose.", new Parameter[]{new Switch("sizes", 's', "sizes", "Compute component sizes."), new Switch("renumber", 'r', "renumber", "Renumber components in decreasing-size order."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new Switch("mapped", 'm', "mapped", "Do not load the graph in main memory, but rather memory-map it."), new FlaggedOption("threads", (StringParser)JSAP.INTSIZE_PARSER, "0", false, 'T', "threads", "The number of threads to be used. If 0, the number will be estimated automatically."), new FlaggedOption("basenamet", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 't', "transpose", "The basename of the transpose, in case the graph is not symmetric."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of a symmetric graph (or of a generic graph, if the transpose is provided, too)."), new UnflaggedOption("resultsBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The basename of the resulting files.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        String basename = jsapResult.getString("basename");
        String basenamet = jsapResult.getString("basenamet");
        String resultsBasename = jsapResult.getString("resultsBasename", basename);
        int threads = jsapResult.getInt("threads");
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        ImmutableGraph immutableGraph = graph = jsapResult.userSpecified("mapped") ? ImmutableGraph.loadMapped(basename) : ImmutableGraph.load(basename, pl);
        ImmutableGraph grapht = basenamet == null ? null : (jsapResult.userSpecified("mapped") ? ImmutableGraph.loadMapped(basenamet) : ImmutableGraph.load(basenamet, pl));
        ConnectedComponents components = ConnectedComponents.compute(basenamet != null ? new UnionImmutableGraph(graph, grapht) : graph, threads, pl);
        if (jsapResult.getBoolean("sizes") || jsapResult.getBoolean("renumber")) {
            int[] size = components.computeSizes();
            if (jsapResult.getBoolean("renumber")) {
                components.sortBySize(size);
            }
            if (jsapResult.getBoolean("sizes")) {
                BinIO.storeInts((int[])size, (CharSequence)(resultsBasename + ".wccsizes"));
            }
        }
        BinIO.storeInts((int[])components.component, (CharSequence)(resultsBasename + ".wcc"));
    }
}

