/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanBigArrays;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.ints.IntBigArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.objects.Object2LongFunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.BVGraph;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.ImmutableSequentialGraph;
import it.unimi.dsi.webgraph.NodeIterator;
import it.unimi.dsi.webgraph.Transform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScatteredArcsASCIIGraph
extends ImmutableSequentialGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScatteredArcsASCIIGraph.class);
    private static final boolean DEBUG = false;
    public static final int DEFAULT_BATCH_SIZE = 1000000;
    private static final String IDS_EXTENSION = ".ids";
    private final Transform.BatchGraph batchGraph;
    public long[] ids;

    public ScatteredArcsASCIIGraph(InputStream is) throws IOException {
        this(is, false);
    }

    public ScatteredArcsASCIIGraph(InputStream is, boolean symmetrize) throws IOException {
        this(is, symmetrize, false);
    }

    public ScatteredArcsASCIIGraph(InputStream is, boolean symmetrize, boolean noLoops) throws IOException {
        this(is, symmetrize, noLoops, 1000000);
    }

    public ScatteredArcsASCIIGraph(InputStream is, boolean symmetrize, boolean noLoops, int batchSize) throws IOException {
        this(is, symmetrize, noLoops, batchSize, null);
    }

    public ScatteredArcsASCIIGraph(InputStream is, boolean symmetrize, boolean noLoops, int batchSize, File tempDir) throws IOException {
        this(is, symmetrize, noLoops, batchSize, tempDir, null);
    }

    public ScatteredArcsASCIIGraph(InputStream is, boolean symmetrize, boolean noLoops, int batchSize, File tempDir, ProgressLogger pl) throws IOException {
        this(is, null, null, -1, symmetrize, noLoops, batchSize, tempDir, pl);
    }

    public ScatteredArcsASCIIGraph(InputStream is, Object2LongFunction<? extends CharSequence> function, Charset charset, int n) throws IOException {
        this(is, function, charset, n, false);
    }

    public ScatteredArcsASCIIGraph(InputStream is, Object2LongFunction<? extends CharSequence> function, Charset charset, int n, boolean symmetrize) throws IOException {
        this(is, function, charset, n, symmetrize, false);
    }

    public ScatteredArcsASCIIGraph(InputStream is, Object2LongFunction<? extends CharSequence> function, Charset charset, int n, boolean symmetrize, boolean noLoops) throws IOException {
        this(is, function, charset, n, symmetrize, noLoops, 1000000);
    }

    public ScatteredArcsASCIIGraph(InputStream is, Object2LongFunction<? extends CharSequence> function, Charset charset, int n, boolean symmetrize, boolean noLoops, int batchSize) throws IOException {
        this(is, function, charset, n, symmetrize, noLoops, batchSize, null);
    }

    public ScatteredArcsASCIIGraph(InputStream is, Object2LongFunction<? extends CharSequence> function, Charset charset, int n, boolean symmetrize, boolean noLoops, int batchSize, File tempDir) throws IOException {
        this(is, function, charset, n, symmetrize, noLoops, batchSize, tempDir, null);
    }

    /*
     * Unable to fully structure code
     */
    public ScatteredArcsASCIIGraph(InputStream is, Object2LongFunction<? extends CharSequence> function, Charset charset, int n, boolean symmetrize, boolean noLoops, int batchSize, File tempDir, ProgressLogger pl) throws IOException {
        super();
        fbis = new FastBufferedInputStream(is);
        map = new Long2IntOpenHashBigMap();
        numNodes = -1;
        if (charset == null) {
            charset = Charset.forName("ISO-8859-1");
        }
        source = new int[batchSize];
        target = new int[batchSize];
        batches = new ObjectArrayList();
        if (pl != null) {
            pl.itemsName = "arcs";
            pl.start((CharSequence)"Creating sorted batches...");
        }
        j = 0;
        pairs = 0L;
        array = new byte[1024];
        line = 1L;
        while (true) {
            block29: {
                block34: {
                    block33: {
                        block31: {
                            block32: {
                                block30: {
                                    start = 0;
                                    while ((len = fbis.readLine(array, start, array.length - start, FastBufferedInputStream.ALL_TERMINATORS)) == array.length - start) {
                                        start += len;
                                        array = ByteArrays.grow((byte[])array, (int)(array.length + 1));
                                    }
                                    if (len == -1) break;
                                    lineLength = start + len;
                                    for (offset = 0; offset < lineLength && array[offset] >= 0 && array[offset] <= 32; ++offset) {
                                    }
                                    if (offset == lineLength || array[0] == 35) break block29;
                                    start = offset;
                                    while (offset < lineLength && (array[offset] < 0 || array[offset] > 32)) {
                                        ++offset;
                                    }
                                    if (function != null) break block30;
                                    try {
                                        sl = ScatteredArcsASCIIGraph.getLong(array, start, offset - start);
                                    }
                                    catch (RuntimeException e) {
                                        ScatteredArcsASCIIGraph.LOGGER.error("Error at line " + line + ": " + e.getMessage());
                                        break block29;
                                    }
                                    s = map.get(sl);
                                    if (s == -1) {
                                        s = (int)map.size();
                                        map.put(sl, s);
                                    }
                                    break block31;
                                }
                                ss = new String(array, start, offset - start, charset);
                                sl = function.getLong((Object)ss);
                                if (sl != -1L) break block32;
                                ScatteredArcsASCIIGraph.LOGGER.warn("Unknown source identifier " + ss + " at line " + line);
                                break block29;
                            }
                            if (sl < 0L || sl >= (long)n) {
                                throw new IllegalArgumentException("Source node number out of range for node " + ss + ": " + sl);
                            }
                            s = (int)sl;
                        }
                        while (offset < lineLength && array[offset] >= 0 && array[offset] <= 32) {
                            ++offset;
                        }
                        if (offset != lineLength) break block33;
                        ScatteredArcsASCIIGraph.LOGGER.error("Error at line " + line + ": no target");
                        break block29;
                    }
                    start = offset;
                    while (offset < lineLength && (array[offset] < 0 || array[offset] > 32)) {
                        ++offset;
                    }
                    if (function != null) break block34;
                    try {
                        tl = ScatteredArcsASCIIGraph.getLong(array, start, offset - start);
                    }
                    catch (RuntimeException e) {
                        ScatteredArcsASCIIGraph.LOGGER.error("Error at line " + line + ": " + e.getMessage());
                        break block29;
                    }
                    t = map.get(tl);
                    if (t == -1) {
                        t = (int)map.size();
                        map.put(tl, t);
                    }
                    ** GOTO lbl89
                }
                ts = new String(array, start, offset - start, charset);
                tl = function.getLong((Object)ts);
                if (tl == -1L) {
                    ScatteredArcsASCIIGraph.LOGGER.warn("Unknown target identifier " + ts + " at line " + line);
                } else {
                    if (tl < 0L || tl >= (long)n) {
                        throw new IllegalArgumentException("Target node number out of range for node " + ts + ": " + tl);
                    }
                    t = (int)tl;
lbl89:
                    // 3 sources

                    while (offset < lineLength && array[offset] >= 0 && array[offset] <= 32) {
                        ++offset;
                    }
                    if (offset < lineLength) {
                        ScatteredArcsASCIIGraph.LOGGER.warn("Trailing characters ignored at line " + line);
                    }
                    if (s != t || !noLoops) {
                        source[j] = s;
                        target[j++] = t;
                        if (j == batchSize) {
                            pairs += (long)Transform.processBatch(batchSize, source, target, tempDir, (List<File>)batches);
                            j = 0;
                        }
                        if (symmetrize && s != t) {
                            source[j] = t;
                            target[j++] = s;
                            if (j == batchSize) {
                                pairs += (long)Transform.processBatch(batchSize, source, target, tempDir, (List<File>)batches);
                                j = 0;
                            }
                        }
                        if (pl != null) {
                            pl.lightUpdate();
                        }
                    }
                }
            }
            ++line;
        }
        if (j != 0) {
            pairs += (long)Transform.processBatch(j, source, target, tempDir, (List<File>)batches);
        }
        if (pl != null) {
            pl.done();
            Transform.logBatches((ObjectArrayList<File>)batches, pairs, pl);
        }
        numNodes = function == null ? (int)map.size() : function.size();
        source = null;
        target = null;
        map.compact();
        keyFile = File.createTempFile(ScatteredArcsASCIIGraph.class.getSimpleName(), "keys", tempDir);
        keyFile.deleteOnExit();
        valueFile = File.createTempFile(ScatteredArcsASCIIGraph.class.getSimpleName(), "values", tempDir);
        valueFile.deleteOnExit();
        BinIO.storeLongs((long[][])map.key, (long)0L, (long)map.size(), (File)keyFile);
        BinIO.storeInts((int[][])map.value, (long)0L, (long)map.size(), (File)valueFile);
        map = null;
        key = BinIO.loadLongsBig((File)keyFile);
        keyFile.delete();
        value = BinIO.loadIntsBig((File)valueFile);
        valueFile.delete();
        if (function == null) {
            this.ids = new long[numNodes];
            result = new long[numNodes];
            i = numNodes;
            while (i-- != 0) {
                result[IntBigArrays.get((int[][])value, (long)((long)i))] = LongBigArrays.get((long[][])key, (long)i);
            }
            this.ids = result;
        }
        key = null;
        value = null;
        this.batchGraph = new Transform.BatchGraph(function == null ? numNodes : n, pairs, (ObjectArrayList<File>)batches);
    }

    private static final long getLong(byte[] array, int offset, int length) {
        if (length == 0) {
            throw new NumberFormatException("Empty number");
        }
        int sign = 1;
        if (array[offset] == 45) {
            sign = -1;
            ++offset;
            --length;
        }
        long value = 0L;
        for (int i = 0; i < length; ++i) {
            byte digit = array[offset + i];
            if (digit < 48 || digit > 57) {
                throw new NumberFormatException("Not a digit: " + (char)digit);
            }
            value *= 10L;
            value += (long)(digit - 48);
        }
        return (long)sign * value;
    }

    public ScatteredArcsASCIIGraph(Iterator<long[]> arcs, boolean symmetrize, boolean noLoops, int batchSize, File tempDir, ProgressLogger pl) throws IOException {
        Long2IntOpenHashBigMap map = new Long2IntOpenHashBigMap();
        int numNodes = -1;
        int[] source = new int[batchSize];
        int[] target = new int[batchSize];
        ObjectArrayList batches = new ObjectArrayList();
        if (pl != null) {
            pl.itemsName = "arcs";
            pl.start((CharSequence)"Creating sorted batches...");
        }
        int j = 0;
        long pairs = 0L;
        while (arcs.hasNext()) {
            long tl;
            int t;
            long[] arc = arcs.next();
            long sl = arc[0];
            int s = map.get(sl);
            if (s == -1) {
                s = (int)map.size();
                map.put(sl, s);
            }
            if ((t = map.get(tl = arc[1])) == -1) {
                t = (int)map.size();
                map.put(tl, t);
            }
            if (s == t && noLoops) continue;
            source[j] = s;
            target[j++] = t;
            if (j == batchSize) {
                pairs += (long)Transform.processBatch(batchSize, source, target, tempDir, (List<File>)batches);
                j = 0;
            }
            if (symmetrize && s != t) {
                source[j] = t;
                target[j++] = s;
                if (j == batchSize) {
                    pairs += (long)Transform.processBatch(batchSize, source, target, tempDir, (List<File>)batches);
                    j = 0;
                }
            }
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (j != 0) {
            pairs += (long)Transform.processBatch(j, source, target, tempDir, (List<File>)batches);
        }
        if (pl != null) {
            pl.done();
            Transform.logBatches((ObjectArrayList<File>)batches, pairs, pl);
        }
        numNodes = (int)map.size();
        source = null;
        target = null;
        map.compact();
        File keyFile = File.createTempFile(ScatteredArcsASCIIGraph.class.getSimpleName(), "keys", tempDir);
        keyFile.deleteOnExit();
        File valueFile = File.createTempFile(ScatteredArcsASCIIGraph.class.getSimpleName(), "values", tempDir);
        valueFile.deleteOnExit();
        BinIO.storeLongs((long[][])map.key, (long)0L, (long)map.size(), (File)keyFile);
        BinIO.storeInts((int[][])map.value, (long)0L, (long)map.size(), (File)valueFile);
        map = null;
        long[][] key = BinIO.loadLongsBig((File)keyFile);
        keyFile.delete();
        int[][] value = BinIO.loadIntsBig((File)valueFile);
        valueFile.delete();
        this.ids = new long[numNodes];
        long[] result = new long[numNodes];
        int i = numNodes;
        while (i-- != 0) {
            result[IntBigArrays.get((int[][])value, (long)((long)i))] = LongBigArrays.get((long[][])key, (long)i);
        }
        this.ids = result;
        key = null;
        value = null;
        this.batchGraph = new Transform.BatchGraph(numNodes, pairs, (ObjectArrayList<File>)batches);
    }

    @Override
    public int numNodes() {
        if (this.batchGraph == null) {
            throw new UnsupportedOperationException("The number of nodes is unknown (you need to exhaust the input)");
        }
        return this.batchGraph.numNodes();
    }

    @Override
    public long numArcs() {
        if (this.batchGraph == null) {
            throw new UnsupportedOperationException("The number of arcs is unknown (you need to exhaust the input)");
        }
        return this.batchGraph.numArcs();
    }

    @Override
    public NodeIterator nodeIterator(int from) {
        return this.batchGraph.nodeIterator(from);
    }

    public static void main(String[] args) throws IllegalArgumentException, SecurityException, IOException, JSAPException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(ScatteredArcsASCIIGraph.class.getName(), "Converts a scattered list of arcs from standard input into a BVGraph. The list ofidentifiers in order of appearance will be saved with extension \".ids\", unless a translation function has been specified.", new Parameter[]{new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new FlaggedOption("batchSize", (StringParser)JSAP.INTSIZE_PARSER, Integer.toString(1000000), false, 's', "batch-size", "The maximum size of a batch, in arcs."), new FlaggedOption("tempDir", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for all temporary batch files."), new Switch("symmetrize", 'S', "symmetrize", "Force the output graph to be symmetric."), new Switch("noLoops", 'L', "no-loops", "Remove loops from the output graph."), new FlaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'f', "function", "A serialised function from strings to longs that will be used to translate identifiers to node numbers."), new FlaggedOption("charset", (StringParser)JSAP.STRING_PARSER, "ISO-8859-1", false, 'C', "charset", "The charset used to read the list of arcs."), new FlaggedOption("n", (StringParser)JSAP.INTSIZE_PARSER, JSAP.NO_DEFAULT, false, 'n', "n", "The number of nodes of the graph (only if you specified a function that does not return the size of the key set, or if you want to override that size)."), new FlaggedOption("comp", (StringParser)JSAP.STRING_PARSER, null, false, 'c', "comp", "A compression flag (may be specified several times).").setAllowMultipleDeclarations(true), new FlaggedOption("windowSize", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(7), false, 'w', "window-size", "Reference window size (0 to disable)."), new FlaggedOption("maxRefCount", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(3), false, 'm', "max-ref-count", "Maximum number of backward references (-1 for \u221e)."), new FlaggedOption("minIntervalLength", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(4), false, 'i', "min-interval-length", "Minimum length of an interval (0 to disable)."), new FlaggedOption("zetaK", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(3), false, 'k', "zeta-k", "The k parameter for zeta-k codes."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the output graph")});
        JSAPResult jsapResult = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        String basename = jsapResult.getString("basename");
        int flags = 0;
        for (String compressionFlag : jsapResult.getStringArray("comp")) {
            try {
                flags |= BVGraph.class.getField(compressionFlag).getInt(BVGraph.class);
            }
            catch (Exception notFound) {
                throw new JSAPException("Compression method " + compressionFlag + " unknown.");
            }
        }
        int windowSize = jsapResult.getInt("windowSize");
        int zetaK = jsapResult.getInt("zetaK");
        int maxRefCount = jsapResult.getInt("maxRefCount");
        if (maxRefCount == -1) {
            maxRefCount = Integer.MAX_VALUE;
        }
        int minIntervalLength = jsapResult.getInt("minIntervalLength");
        Object2LongFunction function = null;
        Charset charset = null;
        int n = -1;
        if (jsapResult.userSpecified("function")) {
            function = (Object2LongFunction)BinIO.loadObject((CharSequence)jsapResult.getString("function"));
            charset = Charset.forName(jsapResult.getString("charset"));
            if (function.size() == -1) {
                if (!jsapResult.userSpecified("n")) {
                    throw new IllegalArgumentException("You must specify a graph size if you specify a translation function that does not return the size of the key set.");
                }
                n = jsapResult.getInt("n");
            } else {
                n = function.size();
            }
        }
        File tempDir = null;
        if (jsapResult.userSpecified("tempDir")) {
            tempDir = new File(jsapResult.getString("tempDir"));
        }
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        ScatteredArcsASCIIGraph graph = new ScatteredArcsASCIIGraph(System.in, (Object2LongFunction<? extends CharSequence>)function, charset, n, jsapResult.userSpecified("symmetrize"), jsapResult.userSpecified("noLoops"), jsapResult.getInt("batchSize"), tempDir, pl);
        BVGraph.store((ImmutableGraph)graph, (CharSequence)basename, windowSize, maxRefCount, minIntervalLength, zetaK, flags, pl);
        if (function == null) {
            BinIO.storeLongs((long[])graph.ids, (CharSequence)(basename + IDS_EXTENSION));
        }
    }

    private static final class Long2IntOpenHashBigMap
    implements Serializable,
    Cloneable,
    Hash {
        public static final long serialVersionUID = 0L;
        public transient long[][] key;
        public transient int[][] value;
        protected transient boolean[][] used;
        protected final float f;
        protected transient long n;
        protected transient long maxFill;
        protected transient long mask;
        protected transient int segmentMask;
        protected transient int baseMask;
        protected long size;

        private void initMasks() {
            this.mask = this.n - 1L;
            this.segmentMask = this.key[0].length - 1;
            this.baseMask = this.key.length - 1;
        }

        public Long2IntOpenHashBigMap(long expected, float f) {
            if (f <= 0.0f || f > 1.0f) {
                throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
            }
            if (this.n < 0L) {
                throw new IllegalArgumentException("The expected number of elements must be nonnegative");
            }
            this.f = f;
            this.n = HashCommon.bigArraySize((long)expected, (float)f);
            this.maxFill = HashCommon.maxFill((long)this.n, (float)f);
            this.key = LongBigArrays.newBigArray((long)this.n);
            this.value = IntBigArrays.newBigArray((long)this.n);
            this.used = BooleanBigArrays.newBigArray((long)this.n);
            this.initMasks();
        }

        public Long2IntOpenHashBigMap() {
            this(16L, 0.75f);
        }

        public int put(long k, int v) {
            long h = HashCommon.murmurHash3((long)k);
            int displ = (int)(h & (long)this.segmentMask);
            int base = (int)((h & this.mask) >>> 27);
            while (this.used[base][displ]) {
                if (k == this.key[base][displ]) {
                    int oldValue = this.value[base][displ];
                    this.value[base][displ] = v;
                    return oldValue;
                }
                base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask;
            }
            this.used[base][displ] = true;
            this.key[base][displ] = k;
            this.value[base][displ] = v;
            if (++this.size >= this.maxFill) {
                this.rehash(2L * this.n);
            }
            return -1;
        }

        public int get(long k) {
            long h = HashCommon.murmurHash3((long)k);
            int displ = (int)(h & (long)this.segmentMask);
            int base = (int)((h & this.mask) >>> 27);
            while (this.used[base][displ]) {
                if (k == this.key[base][displ]) {
                    return this.value[base][displ];
                }
                base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask;
            }
            return -1;
        }

        protected void rehash(long newN) {
            boolean[][] used = this.used;
            long[][] key = this.key;
            int[][] value = this.value;
            boolean[][] newUsed = BooleanBigArrays.newBigArray((long)newN);
            long[][] newKey = LongBigArrays.newBigArray((long)newN);
            int[][] newValue = IntBigArrays.newBigArray((long)newN);
            long newMask = newN - 1L;
            int newSegmentMask = newKey[0].length - 1;
            int newBaseMask = newKey.length - 1;
            int base = 0;
            int displ = 0;
            long i = this.size;
            while (i-- != 0L) {
                while (!used[base][displ]) {
                    base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
                }
                long k = key[base][displ];
                long h = HashCommon.murmurHash3((long)k);
                int d = (int)(h & (long)newSegmentMask);
                int b = (int)((h & newMask) >>> 27);
                while (newUsed[b][d]) {
                    b = b + ((d = d + 1 & newSegmentMask) == 0 ? 1 : 0) & newBaseMask;
                }
                newUsed[b][d] = true;
                newKey[b][d] = k;
                newValue[b][d] = value[base][displ];
                base += (displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0;
            }
            this.n = newN;
            this.key = newKey;
            this.value = newValue;
            this.used = newUsed;
            this.initMasks();
            this.maxFill = HashCommon.maxFill((long)this.n, (float)this.f);
        }

        public void compact() {
            int base = 0;
            int displ = 0;
            int b = 0;
            int d = 0;
            long i = this.size;
            while (i-- != 0L) {
                while (!this.used[base][displ]) {
                    base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask;
                }
                this.key[b][d] = this.key[base][displ];
                this.value[b][d] = this.value[base][displ];
                base = base + ((displ = displ + 1 & this.segmentMask) == 0 ? 1 : 0) & this.baseMask;
                d = d + 1 & this.segmentMask;
                b = b + (d == 0 ? 1 : 0) & this.baseMask;
            }
        }

        public long size() {
            return this.size;
        }
    }
}

