/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongBigArrayBigList;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import it.unimi.dsi.util.ByteBufferLongBigList;
import it.unimi.dsi.webgraph.AbstractLazyIntIterator;
import it.unimi.dsi.webgraph.BVGraph;
import it.unimi.dsi.webgraph.GraphClassParser;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.LazyIntSkippableIterator;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.text.DecimalFormat;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFGraph
extends ImmutableGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(EFGraph.class);
    public static final String GRAPH_EXTENSION = ".graph";
    public static final String OFFSETS_EXTENSION = ".offsets";
    public static final String OFFSETS_BIG_LIST_EXTENSION = ".obl";
    public static final int DEFAULT_CACHE_SIZE = 0x1000000;
    public static final int EFGRAPH_VERSION = 0;
    public static final int DEFAULT_LOG_2_QUANTUM = 8;
    protected final int n;
    protected final int upperBound;
    protected final long m;
    protected final LongBigList graph;
    protected final LongBigList offsets;
    protected final CharSequence basename;
    protected final LongWordBitReader outdegreeLongWordBitReader;
    protected final int log2Quantum;
    protected int cachedNode;
    protected int cachedOutdegree;
    protected long cachedPointer;

    protected EFGraph(CharSequence basename, int n, long m, int upperBound, int log2Quantum, LongBigList graph, LongBigList offsets) {
        this.basename = basename;
        this.n = n;
        this.m = m;
        this.upperBound = upperBound;
        this.log2Quantum = log2Quantum;
        this.graph = graph;
        this.offsets = offsets;
        this.outdegreeLongWordBitReader = new LongWordBitReader(graph, 0);
        this.cachedNode = Integer.MIN_VALUE;
    }

    @Override
    public CharSequence basename() {
        return this.basename;
    }

    public static int lowerBits(long length, long upperBound) {
        return length == 0L ? 0 : Math.max(0, Fast.mostSignificantBit((long)(upperBound / length)));
    }

    public static int pointerSize(long length, long upperBound) {
        return Math.max(0, Fast.ceilLog2((long)(length + (upperBound >>> EFGraph.lowerBits(length, upperBound)))));
    }

    public static long numberOfPointers(long length, long upperBound, int log2Quantum) {
        if (length == 0L) {
            return 0L;
        }
        return upperBound >>> EFGraph.lowerBits(length, upperBound) >>> log2Quantum;
    }

    public static EFGraph load(CharSequence basename) throws IOException {
        return EFGraph.loadInternal(basename, false, null);
    }

    public static EFGraph load(CharSequence basename, ProgressLogger pl) throws IOException {
        return EFGraph.loadInternal(basename, false, pl);
    }

    public static EFGraph loadMapped(CharSequence basename) throws IOException {
        return EFGraph.loadInternal(basename, true, null);
    }

    public static EFGraph loadMapped(CharSequence basename, ProgressLogger pl) throws IOException {
        return EFGraph.loadInternal(basename, true, pl);
    }

    @Deprecated
    public static EFGraph loadSequential(CharSequence basename, ProgressLogger pl) throws IOException {
        return EFGraph.load(basename, pl);
    }

    @Deprecated
    public static EFGraph loadSequential(CharSequence basename) throws IOException {
        return EFGraph.load(basename);
    }

    public static EFGraph loadOffline(CharSequence basename, ProgressLogger pl) throws IOException {
        return EFGraph.loadMapped(basename, pl);
    }

    public static EFGraph loadOffline(CharSequence basename) throws IOException {
        return EFGraph.loadMapped(basename, null);
    }

    public static LongBigArrayBigList loadLongBigList(CharSequence filename, ByteOrder byteOrder) throws IOException {
        long length = new File(filename.toString()).length() / 8L;
        FileChannel channel = new FileInputStream(filename.toString()).getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(65536).order(byteOrder);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        long[][] array = LongBigArrays.newBigArray((long)length);
        long pos = 0L;
        while (channel.read(byteBuffer) > 0) {
            byteBuffer.flip();
            int remainingLongs = byteBuffer.remaining() / 8;
            longBuffer.clear();
            longBuffer.limit(remainingLongs);
            longBuffer.get(array[BigArrays.segment((long)pos)], BigArrays.displacement((long)pos), remainingLongs);
            pos += (long)remainingLongs;
            byteBuffer.clear();
        }
        channel.close();
        return LongBigArrayBigList.wrap((long[][])array);
    }

    protected static EFGraph loadInternal(CharSequence basename, boolean mapped, ProgressLogger pl) throws IOException {
        ByteBufferLongBigList graph;
        ByteOrder byteOrder;
        FileInputStream propertyFile = new FileInputStream(basename + ".properties");
        Properties properties = new Properties();
        properties.load(propertyFile);
        propertyFile.close();
        if (!EFGraph.class.getName().equals(properties.getProperty("graphclass").replace("it.unimi.dsi.big.webgraph", "it.unimi.dsi.webgraph"))) {
            throw new IOException("This class (" + EFGraph.class.getName() + ") cannot load a graph stored using class \"" + properties.getProperty("graphclass") + "\"");
        }
        if (properties.getProperty("version") == null) {
            throw new IOException("Missing format version information");
        }
        if (Integer.parseInt(properties.getProperty("version")) > 0) {
            throw new IOException("This graph uses format " + properties.getProperty("version") + ", but this class can understand only graphs up to format " + 0);
        }
        long nodes = Long.parseLong(properties.getProperty("nodes"));
        if (nodes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The standard version of WebGraph cannot handle graphs with " + nodes + " (>2^31) nodes");
        }
        int n = (int)nodes;
        long m = Long.parseLong(properties.getProperty("arcs"));
        int upperBound = properties.containsKey("upperbound") ? Integer.parseInt(properties.getProperty("upperbound")) : n;
        long quantum = Long.parseLong(properties.getProperty("quantum"));
        int log2Quantum = Fast.mostSignificantBit((long)quantum);
        if (1L << log2Quantum != quantum) {
            throw new IllegalArgumentException("Illegal quantum (must be a power of 2): " + quantum);
        }
        if (properties.get("byteorder").equals(ByteOrder.BIG_ENDIAN.toString())) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else if (properties.get("byteorder").equals(ByteOrder.LITTLE_ENDIAN.toString())) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            throw new IllegalArgumentException("Unknown byte order " + properties.get("byteorder"));
        }
        FileInputStream graphIs = new FileInputStream(basename + GRAPH_EXTENSION);
        if (mapped) {
            graph = ByteBufferLongBigList.map((FileChannel)graphIs.getChannel(), (ByteOrder)byteOrder);
        } else {
            if (pl != null) {
                pl.itemsName = "bytes";
                pl.start((CharSequence)"Loading graph...");
            }
            graph = EFGraph.loadLongBigList(basename + GRAPH_EXTENSION, byteOrder);
            if (pl != null) {
                pl.count = graph.size64() * 8L;
                pl.done();
            }
            graphIs.close();
        }
        if (pl != null) {
            pl.itemsName = "deltas";
            pl.start((CharSequence)"Loading offsets...");
        }
        File offsetsBigListFile = new File(basename + OFFSETS_BIG_LIST_EXTENSION);
        LongBigList offsets = null;
        if (offsetsBigListFile.exists()) {
            if (new File(basename + OFFSETS_EXTENSION).lastModified() > offsetsBigListFile.lastModified()) {
                LOGGER.warn("A cached long big list of offsets was found, but the corresponding offsets file has a later modification time");
            } else {
                try {
                    offsets = (LongBigList)BinIO.loadObject((File)offsetsBigListFile);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warn("A cached long big list of offsets was found, but its class is unknown", (Throwable)e);
                }
            }
        }
        if (offsets == null) {
            InputBitStream offsetIbs = new InputBitStream(basename + OFFSETS_EXTENSION);
            offsets = new EliasFanoMonotoneLongBigList((long)(n + 1), graph.size64() * 64L + 1L, (LongIterator)new OffsetsLongIterator(offsetIbs, n));
            offsetIbs.close();
        }
        if (pl != null) {
            pl.count = n + 1;
            pl.done();
            if (offsets instanceof EliasFanoMonotoneLongBigList) {
                pl.logger().info("Pointer bits per node: " + Util.format((double)((double)((EliasFanoMonotoneLongBigList)offsets).numBits() / ((double)n + 1.0))));
            }
        }
        return new EFGraph(basename, n, m, upperBound, log2Quantum, (LongBigList)graph, offsets);
    }

    public static void store(ImmutableGraph graph, int upperBound, CharSequence basename, ProgressLogger pl) throws IOException {
        EFGraph.store(graph, upperBound, basename, 8, 0x1000000, ByteOrder.nativeOrder(), pl);
    }

    public static void store(ImmutableGraph graph, CharSequence basename, ProgressLogger pl) throws IOException {
        EFGraph.store(graph, basename, 8, 0x1000000, ByteOrder.nativeOrder(), pl);
    }

    public static void store(ImmutableGraph graph, CharSequence basename) throws IOException {
        EFGraph.store(graph, basename, null);
    }

    private static double stirling(double n) {
        return n * Math.log(n) - n + 0.5 * Math.log(Math.PI * 2 * n);
    }

    public static void store(ImmutableGraph graph, CharSequence basename, int log2Quantum, int cacheSize, ByteOrder byteOrder, ProgressLogger pl) throws IOException {
        EFGraph.store(graph, graph.numNodes(), basename, log2Quantum, cacheSize, byteOrder, pl);
    }

    public static void store(ImmutableGraph graph, int upperBound, CharSequence basename, int log2Quantum, int cacheSize, ByteOrder byteOrder, ProgressLogger pl) throws IOException {
        if (log2Quantum < 0) {
            throw new IllegalArgumentException(Integer.toString(log2Quantum));
        }
        Accumulator successorsAccumulator = new Accumulator(cacheSize, log2Quantum);
        FileOutputStream graphOs = new FileOutputStream(basename + GRAPH_EXTENSION);
        FileChannel graphChannel = graphOs.getChannel();
        LongWordOutputBitStream graphStream = new LongWordOutputBitStream(graphChannel, byteOrder);
        OutputBitStream offsets = new OutputBitStream(basename + OFFSETS_EXTENSION);
        long numberOfArcs = 0L;
        long bitsForOutdegrees = 0L;
        long bitsForSuccessors = 0L;
        offsets.writeLongDelta(0L);
        if (pl != null) {
            pl.itemsName = "nodes";
            try {
                pl.expectedUpdates = graph.numNodes();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            pl.start((CharSequence)"Storing...");
        }
        NodeIterator nodeIterator = graph.nodeIterator();
        while (nodeIterator.hasNext()) {
            long successor;
            nodeIterator.nextInt();
            long outdegree = nodeIterator.outdegree();
            numberOfArcs += outdegree;
            long lastSuccessor = 0L;
            int outdegreeBits = graphStream.writeGamma(outdegree);
            bitsForOutdegrees += (long)outdegreeBits;
            successorsAccumulator.init(outdegree, upperBound, false, true, log2Quantum);
            LazyIntIterator successors = nodeIterator.successors();
            while ((successor = (long)successors.nextInt()) != -1L) {
                successorsAccumulator.add(successor - lastSuccessor);
                lastSuccessor = successor;
            }
            long successorsBits = successorsAccumulator.dump(graphStream);
            bitsForSuccessors += successorsBits;
            offsets.writeLongDelta((long)outdegreeBits + successorsBits);
            if (pl == null) continue;
            pl.lightUpdate();
        }
        successorsAccumulator.close();
        graphStream.close();
        graphOs.close();
        offsets.close();
        long n = graph.numNodes();
        if (pl != null) {
            pl.done();
            if (pl.count != n) {
                throw new IllegalStateException("The graph claimed to have " + graph.numNodes() + " nodes, but the node iterator returned " + pl.count);
            }
        }
        DecimalFormat format = new DecimalFormat("0.###");
        long writtenBits = new File(basename + GRAPH_EXTENSION).length() * 8L;
        Properties properties = new Properties();
        properties.setProperty("nodes", String.valueOf(n));
        properties.setProperty("arcs", String.valueOf(numberOfArcs));
        if ((long)upperBound != n) {
            properties.setProperty("upperbound", String.valueOf(upperBound));
        }
        properties.setProperty("quantum", String.valueOf(1L << log2Quantum));
        properties.setProperty("byteorder", byteOrder.toString());
        properties.setProperty("bitsperlink", format.format((double)writtenBits / (double)numberOfArcs));
        properties.setProperty("compratio", format.format((double)writtenBits * Math.log(2.0) / (EFGraph.stirling((double)n * (double)n) - EFGraph.stirling(numberOfArcs) - EFGraph.stirling((double)n * (double)n - (double)numberOfArcs))));
        properties.setProperty("bitspernode", format.format((double)writtenBits / (double)n));
        properties.setProperty("avgbitsforoutdegrees", format.format((double)bitsForOutdegrees / (double)n));
        properties.setProperty("bitsforoutdegrees", Long.toString(bitsForOutdegrees));
        properties.setProperty("bitsforsuccessors", Long.toString(bitsForSuccessors));
        properties.setProperty("graphclass", EFGraph.class.getName());
        properties.setProperty("version", String.valueOf(0));
        FileOutputStream propertyFile = new FileOutputStream(basename + ".properties");
        properties.store(propertyFile, "EFGraph properties");
        propertyFile.close();
    }

    @Override
    public int numNodes() {
        return this.n;
    }

    @Override
    public long numArcs() {
        return this.m;
    }

    @Override
    public boolean randomAccess() {
        return true;
    }

    @Override
    public boolean hasCopiableIterators() {
        return true;
    }

    @Override
    public int outdegree(int x) {
        if (x == this.cachedNode) {
            return this.cachedOutdegree;
        }
        this.cachedNode = x;
        this.cachedOutdegree = (int)this.outdegreeLongWordBitReader.position(this.offsets.getLong((long)this.cachedNode)).readGamma();
        this.cachedPointer = this.outdegreeLongWordBitReader.position();
        return this.cachedOutdegree;
    }

    @Override
    public LazyIntSkippableIterator successors(int x) {
        return new EliasFanoSuccessorReader(this.n, this.upperBound, this.graph, this.outdegree(x), this.cachedPointer, this.log2Quantum);
    }

    @Override
    public EFGraph copy() {
        return new EFGraph(this.basename, this.n, this.m, this.upperBound, this.log2Quantum, (LongBigList)(this.graph instanceof ByteBufferLongBigList ? ((ByteBufferLongBigList)this.graph).copy() : this.graph), this.offsets);
    }

    public static void main(String[] args) throws SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException, JSAPException, ClassNotFoundException, InstantiationException {
        ImmutableGraph graph;
        SimpleJSAP jsap = new SimpleJSAP(BVGraph.class.getName(), "Compresses a graph using the Elias-Fano representation. Source and destination are basenames from which suitable filenames will be stemmed; alternatively, if the suitable option was specified, source is a spec (see below). For more information about the compression techniques, see the Javadoc documentation.", new Parameter[]{new FlaggedOption("graphClass", (StringParser)GraphClassParser.getParser(), null, false, 'g', "graph-class", "Forces a Java class for the source graph."), new Switch("spec", 's', "spec", "The source is not a basename but rather a specification of the form <ImmutableGraphImplementation>(arg,arg,...)."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new FlaggedOption("log2Quantum", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(8), false, 'q', "--log2-quantum", "The base-two logarithm of the indexing quantum."), new Switch("offline", 'o', "offline", "No-op for backward compatibility."), new Switch("once", '1', "once", "Use the read-once load method to read a graph from standard input."), new Switch("list", 'L', "list", "Precomputes an Elias-Fano list of offsets for the source graph."), new Switch("fixedWidthList", 'F', "fixed-width-list", "Precomputes a list of fixed-width offsets for the source graph."), new UnflaggedOption("sourceBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the source graph, or a source spec if --spec was given; it is immaterial when --once is specified."), new UnflaggedOption("destBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The basename of the destination graph; if omitted, no recompression is performed. This is useful in conjunction with --offsets and --list.")});
        JSAPResult jsapResult = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        boolean once = jsapResult.getBoolean("once");
        boolean spec = jsapResult.getBoolean("spec");
        boolean list = jsapResult.getBoolean("list");
        boolean fixedWidthList = jsapResult.getBoolean("fixedWidthList");
        int log2Quantum = jsapResult.getInt("log2Quantum");
        Class graphClass = jsapResult.getClass("graphClass");
        String source = jsapResult.getString("sourceBasename");
        String dest = jsapResult.getString("destBasename");
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        if (graphClass != null) {
            if (spec) {
                System.err.println("Options --graph-class and --spec are incompatible");
                System.exit(1);
            }
            graph = once ? (ImmutableGraph)graphClass.getMethod(ImmutableGraph.LoadMethod.ONCE.toMethod(), InputStream.class).invoke(null, System.in) : (ImmutableGraph)graphClass.getMethod(ImmutableGraph.LoadMethod.OFFLINE.toMethod(), CharSequence.class).invoke(null, source);
        } else {
            graph = !spec ? (once ? ImmutableGraph.loadOnce(System.in) : ImmutableGraph.loadOffline(source, pl)) : (ImmutableGraph)ObjectParser.fromSpec((String)source, ImmutableGraph.class, (String[])GraphClassParser.PACKAGE);
        }
        if (dest != null) {
            if (list || fixedWidthList) {
                throw new IllegalArgumentException("You cannot specify a destination graph with these options");
            }
            EFGraph.store(graph, dest, log2Quantum, 0x1000000, ByteOrder.nativeOrder(), pl);
        } else {
            if (!(graph instanceof EFGraph)) {
                throw new IllegalArgumentException("The source graph is not an EFGraph");
            }
            InputBitStream offsets = new InputBitStream(graph.basename() + OFFSETS_EXTENSION);
            long sizeInBits = new File(graph.basename() + GRAPH_EXTENSION).length() * 8L + 1L;
            OffsetsLongIterator offsetsIterator = new OffsetsLongIterator(offsets, graph.numNodes());
            if (list) {
                BinIO.storeObject((Object)new EliasFanoMonotoneLongBigList((long)(graph.numNodes() + 1), sizeInBits, (LongIterator)offsetsIterator), (CharSequence)(graph.basename() + OFFSETS_BIG_LIST_EXTENSION));
            } else if (fixedWidthList) {
                LongBigList t = LongArrayBitVector.getInstance().asLongBigList(Fast.length((long)sizeInBits));
                while (offsetsIterator.hasNext()) {
                    t.add(offsetsIterator.nextLong());
                }
                BinIO.storeObject((Object)t, (CharSequence)(graph.basename() + OFFSETS_BIG_LIST_EXTENSION));
            }
            offsets.close();
        }
    }

    protected static final class EliasFanoSuccessorReader
    extends AbstractLazyIntIterator
    implements LazyIntSkippableIterator {
        private static final int SKIPPING_THRESHOLD = 8;
        private final long n;
        private final int upperBound;
        protected final LongBigList graph;
        protected final LongWordBitReader skipPointers;
        protected final long skipPointersStart;
        protected final long upperBitsStart;
        private final LongWordBitReader lowerBits;
        private final long lowerBitsStart;
        protected final int log2Quantum;
        protected final int quantum;
        protected final int pointerSize;
        protected final long outdegree;
        protected long window;
        protected long curr;
        public long currentIndex;
        private final int l;
        private int last;

        public EliasFanoSuccessorReader(long n, int upperBound, LongBigList graph, long outdegree, long skipPointersStart, int log2Quantum) {
            this.n = n;
            this.upperBound = upperBound;
            this.graph = graph;
            this.log2Quantum = log2Quantum;
            this.quantum = 1 << log2Quantum;
            this.outdegree = outdegree;
            this.skipPointersStart = skipPointersStart;
            this.l = EFGraph.lowerBits(outdegree + 1L, upperBound);
            long numberOfPointers = EFGraph.numberOfPointers(outdegree + 1L, upperBound, log2Quantum);
            this.pointerSize = EFGraph.pointerSize(outdegree + 1L, upperBound);
            this.lowerBitsStart = skipPointersStart + (long)this.pointerSize * numberOfPointers;
            this.upperBitsStart = this.lowerBitsStart + (long)this.l * (outdegree + 1L);
            this.skipPointers = numberOfPointers == 0L ? null : new LongWordBitReader(graph, this.pointerSize);
            this.lowerBits = new LongWordBitReader(graph, this.l);
            this.lowerBits.position(this.lowerBitsStart);
            this.position(this.upperBitsStart);
            this.last = Integer.MIN_VALUE;
        }

        private void position(long position) {
            this.curr = position / 64L;
            this.window = this.graph.getLong(this.curr) & -1L << (int)position;
        }

        private long getNextUpperBits() {
            while (this.window == 0L) {
                this.window = this.graph.getLong(++this.curr);
            }
            long upperBits = this.curr * 64L + (long)Long.numberOfTrailingZeros(this.window) - this.currentIndex++ - this.upperBitsStart;
            this.window &= this.window - 1L;
            return upperBits;
        }

        @Override
        public int nextInt() {
            if (this.currentIndex >= this.outdegree) {
                this.last = Integer.MAX_VALUE;
                return -1;
            }
            this.last = (int)(this.getNextUpperBits() << this.l | this.lowerBits.extract());
            return this.last;
        }

        @Override
        public int skipTo(int lowerBound) {
            int bitCount;
            if (lowerBound <= this.last) {
                return this.last;
            }
            long zeroesToSkip = lowerBound >>> this.l;
            long delta = zeroesToSkip - (long)((this.last & Integer.MAX_VALUE) >>> this.l);
            assert (delta >= 0L);
            if (delta < 8L) {
                do {
                    this.nextInt();
                } while (this.last < lowerBound);
                return (long)this.last == this.n ? (this.last = Integer.MAX_VALUE) : this.last;
            }
            if (delta > (long)this.quantum) {
                long block = zeroesToSkip >>> this.log2Quantum;
                assert (block > 0L);
                assert (block <= EFGraph.numberOfPointers(this.outdegree + 1L, this.upperBound, this.log2Quantum));
                long blockZeroes = block << this.log2Quantum;
                long skip = this.skipPointers.extract(this.skipPointersStart + (block - 1L) * (long)this.pointerSize);
                assert (skip != 0L);
                this.position(this.upperBitsStart + skip);
                this.currentIndex = skip - blockZeroes;
                delta = zeroesToSkip - this.curr * 64L + this.currentIndex + this.upperBitsStart;
            }
            assert (delta >= 0L) : delta;
            while ((long)(bitCount = Long.bitCount(this.window ^ 0xFFFFFFFFFFFFFFFFL)) < delta) {
                this.window = this.graph.getLong(++this.curr);
                delta -= (long)bitCount;
                this.currentIndex += (long)(64 - bitCount);
            }
            if (delta-- != 0L) {
                long word = this.window ^ 0xFFFFFFFFFFFFFFFFL;
                assert (delta < (long)Long.bitCount(word)) : delta + " >= " + Long.bitCount(word);
                long byteSums = word - ((word & 0xAAAAAAAAAAAAAAAAL) >>> 1);
                byteSums = (byteSums & 0x3333333333333333L) + (byteSums >>> 2 & 0x3333333333333333L);
                byteSums = byteSums + (byteSums >>> 4) & 0xF0F0F0F0F0F0F0FL;
                long rankStep8 = delta * 0x101010101010101L;
                long byteOffset = (((rankStep8 | 0x8080808080808080L) - (byteSums *= 0x101010101010101L) & 0x8080808080808080L) >>> 7) * 0x101010101010101L >>> 53 & 0xFFFFFFFFFFFFFFF8L;
                int byteRank = (int)(delta - (byteSums << 8 >>> (int)byteOffset & 0xFFL));
                int select = (int)(byteOffset + (long)Fast.selectInByte[(int)(word >>> (int)byteOffset & 0xFFL) | byteRank << 8]);
                this.window &= -1L << select;
                this.currentIndex += (long)select - delta;
            }
            long lower = this.lowerBits.extract(this.lowerBitsStart + (long)this.l * this.currentIndex);
            this.last = (int)(this.getNextUpperBits() << this.l | lower);
            while (this.last < lowerBound) {
                this.nextInt();
            }
            return (long)this.last == this.n ? (this.last = Integer.MAX_VALUE) : this.last;
        }

        public String toString() {
            return this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this));
        }
    }

    protected static final class LongWordBitReader {
        private static final boolean DEBUG = false;
        private final LongBigList list;
        private final int l;
        private final int longSizeMinusl;
        private final long mask;
        private long buffer;
        private int filled;
        private long curr;

        public LongWordBitReader(LongBigList list, int l) {
            assert (l < 64);
            this.list = list;
            this.l = l;
            this.longSizeMinusl = 64 - l;
            this.mask = (1L << l) - 1L;
            this.curr = -1L;
        }

        public LongWordBitReader position(long position) {
            this.curr = position / 64L;
            this.buffer = this.list.getLong(this.curr);
            int bitPosition = (int)(position % 64L);
            this.buffer >>>= bitPosition;
            this.filled = 64 - bitPosition;
            return this;
        }

        public long position() {
            return this.curr * 64L + 64L - (long)this.filled;
        }

        private long extractInternal(int width) {
            if (width <= this.filled) {
                long result = this.buffer & (1L << width) - 1L;
                this.filled -= width;
                this.buffer >>>= width;
                return result;
            }
            long result = this.buffer;
            this.buffer = this.list.getLong(++this.curr);
            int remainder = width - this.filled;
            this.buffer >>>= remainder;
            this.filled = 64 - remainder;
            return result |= (this.buffer & (1L << remainder) - 1L) << this.filled;
        }

        public long extract() {
            if (this.l <= this.filled) {
                long result = this.buffer & this.mask;
                this.filled -= this.l;
                this.buffer >>>= this.l;
                return result;
            }
            long result = this.buffer;
            this.buffer = this.list.getLong(++this.curr);
            this.buffer >>>= this.l - this.filled;
            this.filled += this.longSizeMinusl;
            return result |= this.buffer << this.filled & this.mask;
        }

        public long extract(long position) {
            int bitPosition = (int)(position % 64L);
            int totalOffset = bitPosition + this.l;
            this.curr = position / 64L;
            long result = this.list.getLong(this.curr) >>> bitPosition;
            if (totalOffset <= 64) {
                this.buffer = result >>> this.l;
                this.filled = 64 - totalOffset;
                return result & this.mask;
            }
            long t = this.list.getLong(++this.curr);
            this.buffer = t >>> totalOffset;
            this.filled = 128 - totalOffset;
            return result | t << -bitPosition & this.mask;
        }

        public int readUnary() {
            int accumulated = 0;
            while (true) {
                if (this.buffer != 0L) {
                    int msb = Long.numberOfTrailingZeros(this.buffer);
                    this.filled -= msb + 1;
                    this.buffer >>>= msb;
                    this.buffer >>>= 1;
                    return msb + accumulated;
                }
                accumulated += this.filled;
                this.buffer = this.list.getLong(++this.curr);
                this.filled = 64;
            }
        }

        public long readNonZeroGamma() {
            int msb = this.readUnary();
            return this.extractInternal(msb) | 1L << msb;
        }

        public long readGamma() {
            return this.readNonZeroGamma() - 1L;
        }
    }

    private static final class OffsetsLongIterator
    implements LongIterator {
        private final InputBitStream offsetIbs;
        private final long n;
        private long offset;
        private long i;

        private OffsetsLongIterator(InputBitStream offsetIbs, long n) {
            this.offsetIbs = offsetIbs;
            this.n = n;
        }

        public boolean hasNext() {
            return this.i <= this.n;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.i;
            try {
                return this.offset += this.offsetIbs.readLongDelta();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static final class Accumulator
    implements Closeable {
        private static final int MIN_CACHE_SIZE = 16;
        private final LongWordCache successors;
        private final LongWordCache upperBits;
        private final LongWordCache lowerBits;
        private int l;
        private long lowerBitsMask;
        private long length;
        private long currentLength;
        private long currentPrefixSum;
        private long correctedUpperBound;
        private int log2Quantum;
        private long quantum;
        private int pointerSize;
        private long lastOnePosition;
        private long expectedNumberOfPointers;
        public long bitsForUpperBits;
        public long bitsForLowerBits;
        public long bitsForPointers;

        public Accumulator(int bufferSize, int log2Quantum) throws IOException {
            bufferSize &= -bufferSize;
            this.successors = new LongWordCache(Math.max(16, bufferSize >>> Math.max(3, log2Quantum - 3)), "pointers");
            this.lowerBits = new LongWordCache(Math.max(16, bufferSize / 2), "lower");
            this.upperBits = new LongWordCache(Math.max(16, bufferSize / 2), "upper");
        }

        public int lowerBits() {
            return this.l;
        }

        public int pointerSize() {
            return this.pointerSize;
        }

        public long numberOfPointers() {
            return this.expectedNumberOfPointers;
        }

        public void init(long length, long upperBound, boolean strict, boolean indexZeroes, int log2Quantum) {
            this.log2Quantum = log2Quantum;
            this.length = length;
            this.quantum = 1L << log2Quantum;
            this.successors.clear();
            this.lowerBits.clear();
            this.upperBits.clear();
            this.correctedUpperBound = upperBound - (strict ? length : 0L);
            long correctedLength = length + (long)(!strict && indexZeroes ? 1 : 0);
            if (this.correctedUpperBound < 0L) {
                throw new IllegalArgumentException();
            }
            this.currentPrefixSum = 0L;
            this.currentLength = 0L;
            this.lastOnePosition = -1L;
            this.l = EFGraph.lowerBits(correctedLength, upperBound);
            this.lowerBitsMask = (1L << this.l) - 1L;
            this.pointerSize = EFGraph.pointerSize(correctedLength, upperBound);
            this.expectedNumberOfPointers = EFGraph.numberOfPointers(correctedLength, upperBound, log2Quantum);
        }

        public void add(long x) throws IOException {
            if (this.currentLength != 0L && x == 0L) {
                throw new IllegalArgumentException();
            }
            this.currentPrefixSum += x;
            if (this.currentPrefixSum > this.correctedUpperBound) {
                throw new IllegalArgumentException("Too large prefix sum: " + this.currentPrefixSum + " >= " + this.correctedUpperBound);
            }
            if (this.l != 0) {
                this.lowerBits.append(this.currentPrefixSum & this.lowerBitsMask, this.l);
            }
            long onePosition = (this.currentPrefixSum >>> this.l) + this.currentLength;
            this.upperBits.writeUnary((int)(onePosition - this.lastOnePosition - 1L));
            long zeroesBefore = this.lastOnePosition - this.currentLength + 1L;
            long position = this.lastOnePosition + (zeroesBefore & -1L << this.log2Quantum) + this.quantum - zeroesBefore;
            while (position < onePosition) {
                this.successors.append(position + 1L, this.pointerSize);
                position += this.quantum;
                zeroesBefore += this.quantum;
            }
            this.lastOnePosition = onePosition;
            ++this.currentLength;
        }

        public long dump(LongWordOutputBitStream lwobs) throws IOException {
            if (this.currentLength != this.length) {
                throw new IllegalStateException();
            }
            this.add(this.correctedUpperBound - this.currentPrefixSum);
            assert (this.pointerSize == 0 || this.successors.length() / (long)this.pointerSize == this.expectedNumberOfPointers) : "Expected " + this.expectedNumberOfPointers + " pointers, found " + this.successors.length() / (long)this.pointerSize;
            this.bitsForPointers = lwobs.append(this.successors);
            this.bitsForLowerBits = lwobs.append(this.lowerBits);
            this.bitsForUpperBits = lwobs.append(this.upperBits);
            return this.bitsForLowerBits + this.bitsForUpperBits + this.bitsForPointers;
        }

        @Override
        public void close() throws IOException {
            this.successors.close();
            this.upperBits.close();
            this.lowerBits.close();
        }
    }

    public static final class LongWordOutputBitStream {
        private static final int BUFFER_SIZE = 65536;
        private long buffer;
        private final ByteBuffer byteBuffer;
        private int free;
        private final WritableByteChannel writableByteChannel;

        public LongWordOutputBitStream(WritableByteChannel writableByteChannel, ByteOrder byteOrder) {
            this.writableByteChannel = writableByteChannel;
            this.byteBuffer = ByteBuffer.allocateDirect(65536).order(byteOrder);
            this.free = 64;
        }

        public int append(long value, int width) throws IOException {
            assert (width == 64 || (-1L << width & value) == 0L);
            this.buffer |= value << 64 - this.free;
            if (width < this.free) {
                this.free -= width;
            } else {
                this.byteBuffer.putLong(this.buffer);
                if (!this.byteBuffer.hasRemaining()) {
                    this.byteBuffer.flip();
                    this.writableByteChannel.write(this.byteBuffer);
                    this.byteBuffer.clear();
                }
                if (width == this.free) {
                    this.buffer = 0L;
                    this.free = 64;
                } else {
                    this.buffer = value >>> this.free;
                    this.free = 64 - width + this.free;
                }
            }
            return width;
        }

        public long append(long[] value, long length) throws IOException {
            long l = length;
            int i = 0;
            while (l > 0L) {
                int width = (int)Math.min(l, 64L);
                this.append(value[i], width);
                l -= (long)width;
                ++i;
            }
            return length;
        }

        public long append(LongBigList value, long length) throws IOException {
            long l = length;
            long i = 0L;
            while (l > 0L) {
                int width = (int)Math.min(l, 64L);
                this.append(value.getLong(i), width);
                l -= (long)width;
                ++i;
            }
            return length;
        }

        public long append(LongArrayBitVector bv) throws IOException {
            return this.append(bv.bits(), bv.length());
        }

        public long append(LongWordCache cache) throws IOException {
            int width;
            cache.rewind();
            for (long l = cache.length(); l > 0L; l -= (long)width) {
                width = (int)Math.min(l, 64L);
                this.append(cache.readLong(), width);
            }
            return cache.length();
        }

        public int align() throws IOException {
            if (this.free != 64) {
                this.byteBuffer.putLong(this.buffer);
                if (!this.byteBuffer.hasRemaining()) {
                    this.byteBuffer.flip();
                    this.writableByteChannel.write(this.byteBuffer);
                    this.byteBuffer.clear();
                }
                int result = this.free;
                this.buffer = 0L;
                this.free = 64;
                return result;
            }
            return 0;
        }

        public int writeNonZeroGamma(long value) throws IOException {
            if (value <= 0L) {
                throw new IllegalArgumentException("The argument " + value + " is not strictly positive.");
            }
            int msb = Fast.mostSignificantBit((long)value);
            long unary = 1L << msb;
            this.append(unary, msb + 1);
            this.append(value ^ unary, msb);
            return 2 * msb + 1;
        }

        public int writeGamma(long value) throws IOException {
            if (value < 0L) {
                throw new IllegalArgumentException("The argument " + value + " is negative.");
            }
            return this.writeNonZeroGamma(value + 1L);
        }

        public void close() throws IOException {
            this.byteBuffer.putLong(this.buffer);
            this.byteBuffer.flip();
            this.writableByteChannel.write(this.byteBuffer);
            this.writableByteChannel.close();
        }
    }

    protected static final class LongWordCache
    implements Closeable {
        private final File spillFile;
        private final FileChannel spillChannel;
        private final ByteBuffer cache;
        private long buffer;
        private int free;
        private final long cacheLength;
        private long length;
        private boolean spillMustBeRewind;

        public LongWordCache(int cacheSize, String suffix) throws IOException {
            this.spillFile = File.createTempFile(EFGraph.class.getName(), suffix);
            this.spillFile.deleteOnExit();
            this.spillChannel = new RandomAccessFile(this.spillFile, "rw").getChannel();
            this.cache = ByteBuffer.allocateDirect(cacheSize).order(ByteOrder.nativeOrder());
            this.cacheLength = (long)cacheSize * 8L;
            this.free = 64;
        }

        private void flushBuffer() throws IOException {
            this.cache.putLong(this.buffer);
            if (!this.cache.hasRemaining()) {
                if (this.spillMustBeRewind) {
                    this.spillMustBeRewind = false;
                    this.spillChannel.position(0L);
                }
                this.cache.flip();
                this.spillChannel.write(this.cache);
                this.cache.clear();
            }
        }

        public int append(long value, int width) throws IOException {
            assert (width == 64 || (-1L << width & value) == 0L);
            this.buffer |= value << 64 - this.free;
            this.length += (long)width;
            if (width < this.free) {
                this.free -= width;
            } else {
                this.flushBuffer();
                if (width == this.free) {
                    this.buffer = 0L;
                    this.free = 64;
                } else {
                    this.buffer = value >>> this.free;
                    this.free = 64 - width + this.free;
                }
            }
            return width;
        }

        public void clear() {
            this.buffer = 0L;
            this.length = 0L;
            this.free = 64;
            this.cache.clear();
            this.spillMustBeRewind = true;
        }

        @Override
        public void close() throws IOException {
            this.spillChannel.close();
            this.spillFile.delete();
        }

        public long length() {
            return this.length;
        }

        public void writeUnary(int l) throws IOException {
            if (l >= this.free) {
                l -= this.free;
                this.length += (long)this.free;
                this.flushBuffer();
                this.buffer = 0L;
                this.free = 64;
                while (l >= 64) {
                    this.flushBuffer();
                    l -= 64;
                    this.length += 64L;
                }
            }
            this.append(1L << l, l + 1);
        }

        public long readLong() throws IOException {
            if (!this.cache.hasRemaining()) {
                this.cache.clear();
                this.spillChannel.read(this.cache);
                this.cache.flip();
            }
            return this.cache.getLong();
        }

        public void rewind() throws IOException {
            if (this.free != 64) {
                this.cache.putLong(this.buffer);
            }
            if (this.length > this.cacheLength) {
                this.cache.flip();
                this.spillChannel.write(this.cache);
                this.spillChannel.position(0L);
                this.cache.clear();
                this.spillChannel.read(this.cache);
                this.cache.flip();
            } else {
                this.cache.rewind();
            }
        }
    }
}

