/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.LazyIntIterators;
import it.unimi.dsi.webgraph.NodeIterator;
import it.unimi.dsi.webgraph.Transform;
import java.util.ConcurrentModificationException;

public class ArrayListMutableGraph {
    protected int n;
    protected long m;
    protected IntArrayList[] successors;
    private static final IntArrayList[] EMPTY_INTARRAYLIST_ARRAY = new IntArrayList[0];
    protected ImmutableView immutableView;
    protected int modificationCount = 0;
    protected int lastModificationCount = -1;

    protected void ensureNode(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("Illegal node index " + x);
        }
        if (x >= this.n) {
            throw new IllegalArgumentException("Node index " + x + " is larger than graph order (" + this.n + ")");
        }
    }

    public ArrayListMutableGraph() {
        this.successors = EMPTY_INTARRAYLIST_ARRAY;
    }

    public ArrayListMutableGraph(int numNodes) {
        this.n = numNodes;
        this.successors = new IntArrayList[this.n];
        int i = this.n;
        while (i-- != 0) {
            this.successors[i] = new IntArrayList();
        }
    }

    public ArrayListMutableGraph(int numNodes, int[][] arc) {
        this(numNodes);
        this.m = arc.length;
        int i = arc.length;
        while (i-- != 0) {
            if (arc[i].length != 2) {
                throw new IllegalArgumentException("The arc of index " + i + " has length " + arc[i].length);
            }
            if (arc[i][0] >= 0 && arc[i][1] >= 0 && arc[i][0] < numNodes && arc[i][1] < numNodes) continue;
            throw new IllegalArgumentException("The arc of index " + i + " (" + arc[i][0] + ", " + arc[i][1] + ") is illegal");
        }
        for (i = 0; i < arc.length; ++i) {
            this.successors[arc[i][0]].add(arc[i][1]);
        }
    }

    public ArrayListMutableGraph(ImmutableGraph g) {
        this();
        int s = -1;
        long numArcs = 0L;
        NodeIterator nodeIterator = g.nodeIterator();
        while (nodeIterator.hasNext()) {
            s = nodeIterator.nextInt();
            int d = nodeIterator.outdegree();
            numArcs += (long)d;
            this.successors = (IntArrayList[])ObjectArrays.grow((Object[])this.successors, (int)(s + 1));
            this.successors[s] = new IntArrayList(nodeIterator.successorArray(), 0, d);
        }
        this.n = s + 1;
        this.m = numArcs;
    }

    public ArrayListMutableGraph(int numNodes, Transform.ArcFilter arcFilter) {
        this(numNodes);
        int i = this.n;
        while (i-- != 0) {
            for (int j = 0; j < this.n; ++j) {
                if (!arcFilter.accept(i, j)) continue;
                this.successors[i].add(j);
                ++this.m;
            }
        }
    }

    public static ArrayListMutableGraph newDirectedCycle(final int numNodes) {
        return new ArrayListMutableGraph(numNodes, new Transform.ArcFilter(){

            @Override
            public boolean accept(int i, int j) {
                return (i + 1) % numNodes == j;
            }
        });
    }

    public static ArrayListMutableGraph newBidirectionalCycle(final int numNodes) {
        return new ArrayListMutableGraph(numNodes, new Transform.ArcFilter(){

            @Override
            public boolean accept(int i, int j) {
                return (i + 1) % numNodes == j || (j + 1) % numNodes == i;
            }
        });
    }

    public static ArrayListMutableGraph newCompleteGraph(int numNodes, final boolean loops) {
        return new ArrayListMutableGraph(numNodes, new Transform.ArcFilter(){

            @Override
            public boolean accept(int i, int j) {
                return i != j || loops;
            }
        });
    }

    public static ArrayListMutableGraph newCompleteBinaryIntree(int height) {
        return new ArrayListMutableGraph((1 << height + 1) - 1, new Transform.ArcFilter(){

            @Override
            public boolean accept(int i, int j) {
                return i != j && (i - 1) / 2 == j;
            }
        });
    }

    public static ArrayListMutableGraph newCompleteBinaryOuttree(int height) {
        return new ArrayListMutableGraph((1 << height + 1) - 1, new Transform.ArcFilter(){

            @Override
            public boolean accept(int i, int j) {
                return i != j && (j - 1) / 2 == i;
            }
        });
    }

    public ImmutableGraph immutableView() {
        if (this.modificationCount != this.lastModificationCount) {
            int i = this.n;
            while (i-- != 0) {
                IntArrays.quickSort((int[])this.successors[i].elements(), (int)0, (int)this.successors[i].size());
            }
            this.immutableView = new ImmutableView(this);
        }
        this.lastModificationCount = this.modificationCount;
        return this.immutableView;
    }

    public int numNodes() {
        return this.n;
    }

    public int outdegree(int x) {
        this.ensureNode(x);
        return this.successors[x].size();
    }

    public long numArcs() {
        return this.m;
    }

    public int[] successorArray(int x) {
        this.ensureNode(x);
        return this.successors[x].toIntArray();
    }

    public IntIterator successors(int x) {
        this.ensureNode(x);
        return this.successors[x].iterator();
    }

    public void addNodes(int numNewNodes) {
        if (numNewNodes != 0) {
            ++this.modificationCount;
            int newN = this.n + numNewNodes;
            this.successors = (IntArrayList[])ObjectArrays.ensureCapacity((Object[])this.successors, (int)newN, (int)this.n);
            while (this.n < newN) {
                this.successors[this.n++] = new IntArrayList();
            }
        }
    }

    public void removeNode(int x) {
        this.ensureNode(x);
        ++this.modificationCount;
        System.arraycopy(this.successors, x + 1, this.successors, x, --this.n - x);
        int i = this.n;
        while (i-- != 0) {
            int j = this.successors[i].size();
            while (j-- != 0) {
                int t = this.successors[i].getInt(j);
                if (t == x) {
                    this.successors[i].removeInt(j);
                    continue;
                }
                if (t <= x) continue;
                this.successors[i].set(j, t - 1);
            }
        }
    }

    public void addArc(int x, int y) {
        this.ensureNode(x);
        this.ensureNode(y);
        if (this.successors[x].indexOf(y) != -1) {
            throw new IllegalArgumentException("Node " + y + " is already a successor of node " + x);
        }
        ++this.modificationCount;
        this.successors[x].add(y);
        ++this.m;
    }

    public void removeArc(int x, int y) {
        this.ensureNode(x);
        this.ensureNode(y);
        int pos = this.successors[x].indexOf(y);
        if (pos == -1) {
            throw new IllegalArgumentException("Node " + y + " is not a successor of node " + x);
        }
        ++this.modificationCount;
        this.successors[x].removeInt(pos);
        --this.m;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ArrayListMutableGraph)) {
            return false;
        }
        ArrayListMutableGraph g = (ArrayListMutableGraph)o;
        int n = this.numNodes();
        if (n != g.numNodes()) {
            return false;
        }
        while (n-- != 0) {
            int d = this.outdegree(n);
            if (d != g.outdegree(n)) {
                return false;
            }
            int[] s = this.successorArray(n);
            int[] t = g.successorArray(n);
            while (d-- != 0) {
                if (s[d] == t[d]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = this.numNodes();
        int h = -1;
        for (int i = 0; i < n; ++i) {
            h = h * 31 + i;
            int[] s = this.successorArray(i);
            int d = this.outdegree(i);
            while (d-- != 0) {
                h = h * 31 + s[d];
            }
        }
        return h;
    }

    public String toString() {
        MutableString ms = new MutableString();
        ms.append("Nodes: " + this.numNodes() + "\nArcs: " + this.numArcs() + "\n");
        for (int i = 0; i < this.numNodes(); ++i) {
            ms.append("Successors of " + i + " (degree " + this.outdegree(i) + "):");
            IntIterator ii = this.successors(i);
            while (ii.hasNext()) {
                ms.append(" " + ii.nextInt());
            }
            ms.append("\n");
        }
        return ms.toString();
    }

    private static class ImmutableView
    extends ImmutableGraph {
        private final int n;
        private final long m;
        private final IntArrayList[] successors;
        private final ArrayListMutableGraph g;

        public ImmutableView(ArrayListMutableGraph g) {
            this.g = g;
            this.n = g.n;
            this.m = g.m;
            this.successors = g.successors;
        }

        @Override
        public ImmutableView copy() {
            return this;
        }

        private void ensureUnmodified() {
            if (this.g.modificationCount != this.g.lastModificationCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int numNodes() {
            this.ensureUnmodified();
            return this.n;
        }

        @Override
        public int outdegree(int x) {
            this.ensureUnmodified();
            return this.successors[x].size();
        }

        @Override
        public long numArcs() {
            this.ensureUnmodified();
            return this.m;
        }

        @Override
        public boolean randomAccess() {
            return true;
        }

        @Override
        public int[] successorArray(int x) {
            this.ensureUnmodified();
            return this.successors[x].toIntArray();
        }

        @Override
        public LazyIntIterator successors(int x) {
            this.ensureUnmodified();
            return LazyIntIterators.lazy((IntIterator)this.successors[x].iterator());
        }
    }
}

