/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph;

import com.google.common.base.Charsets;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ArrayListMutableGraph;
import it.unimi.dsi.webgraph.GraphClassParser;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.ImmutableSequentialGraph;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArcListASCIIGraph
extends ImmutableSequentialGraph {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(ArcListASCIIGraph.class);
    private int n;
    private final FastBufferedReader fbr;
    private final int shift;

    public ArcListASCIIGraph(InputStream is, int shift) throws NumberFormatException, IOException {
        this.shift = shift;
        this.fbr = new FastBufferedReader((Reader)new InputStreamReader(is, "ASCII"));
        this.n = -1;
    }

    @Override
    public int numNodes() {
        if (this.n == -1) {
            throw new UnsupportedOperationException("The number of nodes is unknown (you need to complete a traversal)");
        }
        return this.n;
    }

    @Override
    public NodeIterator nodeIterator(final int from) {
        if (from < 0) {
            throw new IllegalArgumentException();
        }
        try {
            final StreamTokenizer st = new StreamTokenizer((Reader)this.fbr);
            st.eolIsSignificant(true);
            st.parseNumbers();
            return new NodeIterator(){
                int maxNodeSeen;
                int following = -1;
                int curr = -1;
                boolean eof;
                IntArrayList successors = new IntArrayList();
                {
                    this.fillNextLine();
                    for (int i = 0; i < from; ++i) {
                        this.nextInt();
                    }
                }

                private void ensureNumberToken() {
                    if (st.ttype != -2 || st.nval != (double)((int)st.nval)) {
                        throw new IllegalArgumentException("Expected integer, found " + st.toString());
                    }
                    if ((int)st.nval + ArcListASCIIGraph.this.shift < 0) {
                        throw new IllegalArgumentException("Integer plus shift is negative: " + st.toString());
                    }
                }

                private void fillNextLine() throws IOException {
                    if (this.eof) {
                        return;
                    }
                    this.successors.clear();
                    if (this.following == -1) {
                        while (st.nextToken() == 10) {
                        }
                        this.ensureNumberToken();
                    }
                    if (this.following > (int)st.nval + ArcListASCIIGraph.this.shift) {
                        throw new IllegalArgumentException("Source nodes must be sorted");
                    }
                    this.following = (int)st.nval + ArcListASCIIGraph.this.shift;
                    if (this.following > this.maxNodeSeen) {
                        this.maxNodeSeen = this.following;
                    }
                    st.nextToken();
                    this.ensureNumberToken();
                    int successor = (int)st.nval + ArcListASCIIGraph.this.shift;
                    this.successors.add(successor);
                    if (successor > this.maxNodeSeen) {
                        this.maxNodeSeen = successor;
                    }
                    st.nextToken();
                    while (true) {
                        int nextToken;
                        if ((nextToken = st.nextToken()) == -1) {
                            this.eof = true;
                            ArcListASCIIGraph.this.n = this.maxNodeSeen + 1;
                            break;
                        }
                        if (nextToken == 10) continue;
                        this.ensureNumberToken();
                        if ((int)st.nval + ArcListASCIIGraph.this.shift != this.following) {
                            if (this.following > (int)st.nval + ArcListASCIIGraph.this.shift) {
                                throw new IllegalArgumentException("Source nodes must be sorted");
                            }
                            if ((int)st.nval + ArcListASCIIGraph.this.shift <= this.maxNodeSeen) break;
                            this.maxNodeSeen = (int)st.nval + ArcListASCIIGraph.this.shift;
                            break;
                        }
                        st.nextToken();
                        this.ensureNumberToken();
                        successor = (int)st.nval + ArcListASCIIGraph.this.shift;
                        this.successors.add(successor);
                        if (successor > this.maxNodeSeen) {
                            this.maxNodeSeen = successor;
                        }
                        st.nextToken();
                    }
                    IntArrays.quickSort((int[])this.successors.elements(), (int)0, (int)this.successors.size());
                }

                public boolean hasNext() {
                    return this.curr < this.maxNodeSeen;
                }

                @Override
                public int[] successorArray() {
                    if (this.curr == -1) {
                        throw new IllegalStateException();
                    }
                    return this.curr == this.following ? this.successors.elements() : IntArrays.EMPTY_ARRAY;
                }

                public final int nextInt() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    if (++this.curr > this.following) {
                        try {
                            this.fillNextLine();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return this.curr;
                }

                @Override
                public int outdegree() {
                    if (this.curr == -1) {
                        throw new IllegalStateException();
                    }
                    return this.curr == this.following ? this.successors.size() : 0;
                }

                @Override
                public NodeIterator copy(int upperBound) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NodeIterator[] splitNodeIterators(int howMany) {
        Object[] result = new NodeIterator[howMany];
        result[0] = this.nodeIterator();
        Arrays.fill(result, 1, result.length, NodeIterator.EMPTY);
        return result;
    }

    @Deprecated
    public static ImmutableGraph loadSequential(CharSequence basename) throws IOException {
        return ArcListASCIIGraph.load(basename);
    }

    @Deprecated
    public static ImmutableGraph loadSequential(CharSequence basename, ProgressLogger unused) throws IOException {
        return ArcListASCIIGraph.load(basename);
    }

    public static ImmutableGraph loadOffline(CharSequence basename) throws IOException {
        return ArcListASCIIGraph.load(basename);
    }

    public static ImmutableGraph loadOffline(CharSequence basename, ProgressLogger unused) throws IOException {
        return ArcListASCIIGraph.load(basename);
    }

    public static ImmutableGraph loadMapped(CharSequence basename) throws IOException {
        return ArcListASCIIGraph.load(basename);
    }

    public static ImmutableGraph loadMapped(CharSequence basename, ProgressLogger unused) throws IOException {
        return ArcListASCIIGraph.load(basename);
    }

    public static ArcListASCIIGraph loadOnce(InputStream is) throws IOException {
        return new ArcListASCIIGraph(is, 0);
    }

    public static ArcListASCIIGraph loadOnce(InputStream is, int shift) throws IOException {
        return new ArcListASCIIGraph(is, shift);
    }

    public static ImmutableGraph load(CharSequence basename) throws IOException {
        return ArcListASCIIGraph.load(basename, null);
    }

    public static ImmutableGraph load(CharSequence basename, ProgressLogger unused) throws IOException {
        return new ArrayListMutableGraph(ArcListASCIIGraph.loadOnce((InputStream)new FastBufferedInputStream((InputStream)new FileInputStream(basename.toString())))).immutableView();
    }

    public static void store(ImmutableGraph graph, CharSequence basename, ProgressLogger unused) throws IOException {
        ArcListASCIIGraph.store(graph, basename);
    }

    public static void store(ImmutableGraph graph, CharSequence basename) throws IOException {
        ArcListASCIIGraph.store(graph, basename, 0);
    }

    public static void store(ImmutableGraph graph, CharSequence basename, int shift) throws IOException {
        PrintStream ps = new PrintStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(basename.toString())), false, Charsets.US_ASCII.toString());
        NodeIterator nodeIterator = graph.nodeIterator();
        while (nodeIterator.hasNext()) {
            int s = nodeIterator.nextInt();
            int d = nodeIterator.outdegree();
            int[] successor = nodeIterator.successorArray();
            for (int i = 0; i < d; ++i) {
                ps.println(s + shift + "\t" + (successor[i] + shift));
            }
        }
        ps.close();
    }

    public static void main(String[] args) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException, JSAPException {
        ImmutableGraph graph;
        SimpleJSAP jsap = new SimpleJSAP(ArcListASCIIGraph.class.getName(), "Reads a graph with a given basename and writes it out in ASCII format with another basename", new Parameter[]{new FlaggedOption("graphClass", (StringParser)GraphClassParser.getParser(), null, false, 'g', "graph-class", "Forces a Java class for the source graph"), new FlaggedOption("shift", (StringParser)JSAP.INTEGER_PARSER, null, false, 'S', "shift", "A shift that will be added to each node index."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new UnflaggedOption("sourceBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the source graph"), new UnflaggedOption("destBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the destination graph")});
        JSAPResult jsapResult = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        Class graphClass = jsapResult.getClass("graphClass");
        String sourceBasename = jsapResult.getString("sourceBasename");
        String destBasename = jsapResult.getString("destBasename");
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        ImmutableGraph immutableGraph = graph = graphClass != null ? (ImmutableGraph)graphClass.getMethod("loadOffline", CharSequence.class, ProgressLogger.class).invoke(null, sourceBasename, pl) : ImmutableGraph.loadOffline(sourceBasename, pl);
        if (jsapResult.userSpecified("shift")) {
            ArcListASCIIGraph.store(graph, (CharSequence)destBasename, jsapResult.getInt("shift"));
        } else {
            ArcListASCIIGraph.store(graph, destBasename);
        }
    }
}

